// checkIfSessionAlive-CoP.php
function isOnAlive() {
  // Check if browser is online
  if (!navigator.onLine) {
    alert("You're currently offline. Please check your connection and refresh your browser.");
    return false;
  }
  checkSession();
}

function checkIfOnlineAndSession() {
  return new Promise((resolve, reject) => {
    if (!navigator.onLine) {
      alert("You're currently offline. Please check your connection and refresh your browser.");
      return resolve(false);
    }

    console.log("Checking session...");

    const xhr = new XMLHttpRequest();
    xhr.open("GET", "/_includes/session_check.php", true);
    xhr.onreadystatechange = function () {
      if (xhr.readyState === 4 && xhr.status === 200) {
        const response = JSON.parse(xhr.responseText);
        console.log("is Alive? = " + response.status);

        if (response.status === "expired") {
          document.getElementById("sessionModal").style.display = "block";
          resolve(false);
        } else {
          resolve(true);
        }
      }
    };
    xhr.send();
  });
}

/* good no promises
function checkIfOnlineAndSession() {
  setTimeout(function () {
    if (!navigator.onLine) {
      alert("You're currently offline. Please check your connection and refresh your browser.");
      return false;
    }

    console.log("Checking session...");

    const xhr = new XMLHttpRequest();
    xhr.open("GET", "/_includes/session_check.php", true);
    xhr.onreadystatechange = function () {
      if (xhr.readyState === 4 && xhr.status === 200) {
        const response = JSON.parse(xhr.responseText);
        console.log("is Alive? = " + response.status);

        if (response.status === "expired") {
          document.getElementById("sessionModal").style.display = "block";
          return false;
       
        }
      }
    };
    xhr.send();
  }, 2000); // 2-second delay
}
*/
/*
function checkIfOnlineAndSession() {
  if (!navigator.onLine) {
    alert("You're currently offline. Please check your connection and refresh your browser.");
    return false;
  }
    console.log("Checking session...");
  const xhr = new XMLHttpRequest();
  xhr.open("GET", "/_includes/session_check.php", true);
  xhr.onreadystatechange = function () {
    if (xhr.readyState === 4 && xhr.status === 200) {
      const response = JSON.parse(xhr.responseText);
      if (response.status === "expired") {
        document.getElementById("sessionModal").style.display = "block"; 
      }else{
        return true;
      }
      console.log("is Alive? = "+response.status)
    }
  };
  xhr.send();
}
  */