// Toggle weekend flags on/off
const showWeekendFlags = false;

// Event types
const TYPE_ORDER = ["Cabinetry","Doors","Service","Hardware"];

// Utility: get YYYY-MM-DD strings between two JS Date objects
function getDatesInRange(startDate, endDate) {
  const dates = [];
  const cur = new Date(startDate);
  while (cur <= endDate) {
    dates.push(cur.toISOString().slice(0,10));
    cur.setDate(cur.getDate() + 1);
  }
  return dates;
}

// Parse "YYYY-MM-DD" as a local date, then check weekend
function isWeekend(dateStr) {
  const [y,m,d] = dateStr.split("-").map(Number);
  const dt = new Date(y, m - 1, d);
  return dt.getDay() === 0 || dt.getDay() === 6;
}

let currentDate, events, jobsList;

function loadCalendarData() {
   document.getElementById("modal").style.display   = "none";
  document.getElementById("modalOverlay").style.display   = "none";
  $.ajax({
    url: '/_includes/getCalendar.php',
    method: 'GET',
    dataType: 'json',
    success(data) {
      currentDate = new Date(data.currentDate);
      events      = data.events;
      jobsList    = data.jobs;
      generateCalendar(
        currentDate.getFullYear(),
        currentDate.getMonth()
      );
    },
    error(xhr, st, err) {
      console.error("fetch failed:", err);
    }
  });
}

function generateCalendar(year, month) {
  const daysContainer  = document.querySelector(".days");
  const monthYearLabel = document.getElementById("monthYear");
  daysContainer.innerHTML = "";

  // 1) Month header
  const monthNames = [
    "January","February","March","April","May","June",
    "July","August","September","October","November","December"
  ];
  monthYearLabel.textContent = `${monthNames[month]} ${year}`;

  // 2) Calculate layout
  const firstDow  = new Date(year, month, 1).getDay();
  const totalDays = new Date(year, month + 1, 0).getDate();
  const today     = new Date();
  const isCurr    = today.getFullYear() === year && today.getMonth() === month;
  const todayNum  = isCurr ? today.getDate() : null;

  // 3) Leading empty slots
  for (let i = 0; i < firstDow; i++) {
    const empty = document.createElement("div");
    empty.classList.add("day", "empty");
    daysContainer.appendChild(empty);
  }

  // 4) Build each day cell
  for (let d = 1; d <= totalDays; d++) {
    const dateKey = `${year}-${String(month+1).padStart(2,"0")}-${String(d).padStart(2,"0")}`;
    const cell    = document.createElement("div");
    cell.classList.add("day");
    cell.dataset.date = dateKey;
    if (d === todayNum) cell.classList.add("today");

    // 4a) Header: number + placeholder for flags
    const header = document.createElement("div");
    header.classList.add("day-header");
    const num = document.createElement("span");
    num.classList.add("day-number");
    num.textContent = d;
    const flags = document.createElement("div");
    flags.classList.add("event-flags");
    header.append(num, flags);
    cell.appendChild(header);

    // 4b) Bottom badges for service‐date events
    const dayEvents = events[dateKey] || [];
    if (dayEvents.length) {
      const counts = TYPE_ORDER.reduce((o, t) => (o[t] = 0, o), {});
      dayEvents.forEach(evt => counts[evt.type]++);
      const icons = document.createElement("div");
      icons.classList.add("event-icons");
      for (const t of TYPE_ORDER) {
        if (counts[t] > 0) {
          const badge = document.createElement("div");
          badge.classList.add("event-icon", `event-${t.toLowerCase()}`);
          badge.textContent = `${counts[t]}-${t}`;
          icons.appendChild(badge);
        }
      }
      cell.appendChild(icons);
      //cell.onclick = () => showModal(dateKey);
    }

    daysContainer.appendChild(cell);
  }

  // 5) Inject multi-day flags (dots), skipping the start date
  const allEvents = Object.values(events).flat();
  allEvents.forEach(evt => {
    if (!evt.startDate || !evt.endDate) return;

    // build full span
    const spanDates = getDatesInRange(
      new Date(evt.startDate),
      new Date(evt.endDate)
    );

    // if truly multi-day, drop the very first date
    if (spanDates.length > 1) {
      spanDates.shift();
    } else {
      // single-day; nothing to do
      return;
    }

    // now append a dot on each remaining date 
    spanDates.forEach(dateStr => {
      // optional: skip weekends if showWeekendFlags===false
      if (!showWeekendFlags && isWeekend(dateStr)) return;

      const cell = document.querySelector(`.day[data-date="${dateStr}"]`);
      if (!cell) return;
      const container = cell.querySelector(".event-flags");
      const cls = `event-flag event-${evt.type.toLowerCase()}`;
      if (!container.querySelector(`.${cls.replace(/ /g,'.')}`)) {
        const dot = document.createElement("span");
        dot.className = cls;
/////////////////////////////////////
////////////////////////////////////
const count = getOngoingJobCount(dateStr, evt.type);
dot.className = `${cls} dot-count`;
dot.textContent = count > 0 ? count : "";
///////////////////////////////////// 
////////////////////////////////////

        dot.addEventListener("click", e => {
        e.stopPropagation();     // prevent cell’s own click
        showModal(dateStr);      // open the same modal you already have
        });
        

        container.appendChild(dot);
      }
    });
  });
    // ──────────────────────────────────────────────
  // 6) Attach click to day cells that contain badges or dots
  document
    .querySelectorAll('.day[data-date]')
    .forEach(cell => {
      const dateKey       = cell.dataset.date;
      const hasBadge      = cell.querySelector('.event-icons .event-icon');
      const hasDot        = cell.querySelector('.event-flags .event-flag');

      if (hasBadge || hasDot) {
        // show pointer on hover
        cell.style.cursor = 'pointer';

        // open the modal for this date
        cell.addEventListener('click', () => {
          showModal(dateKey);
        });
      }
    });
  // ──────────────────────────────────────────────

}


// Month nav & modal funcs unchanged...
function changeMonth(dir){
  currentDate.setMonth(currentDate.getMonth()+dir);
  generateCalendar(currentDate.getFullYear(), currentDate.getMonth());
}



////////////////////////////////////
///////////////////////////////////

/* good */
function getOngoingJobCount(dateStr, type) {
  let count = 0;

  for (const date in events) {
    const jobs = events[date];
    for (const job of jobs) {
      const start = job.startDate;
      const end = job.endDate;
      const jobType = job.type.toLowerCase();

      if (
        jobType === type.toLowerCase() &&
        start < dateStr && // exclude jobs starting on dot day
        dateStr <= end
      ) {
        count++;
      }
    }
  }

  return count;
}
  




/*
function getOngoingJobCount(dateStr, type) {
  let count = 0;

  for (const date in events) {
    const jobs = events[date];
    for (const job of jobs) {
      const start = job.startDate;
      const end = job.endDate;
      const jobType = job.type.toLowerCase();

      if (
        jobType === type.toLowerCase() &&
        start <= dateStr &&
        dateStr <= end
      ) {
        count++;
      }
    }
  }

  return count;
}
*/






////////////////////////////////////
////////////////////////////////////




/*
function showModal(dateKey) {
  const modal   = document.getElementById("modal");
  const overlay = document.getElementById("modalOverlay");
  const header  = document.getElementById("modalHeader");
  const content = document.getElementById("modalContent");

  // Normalize the date string
  const target = dateKey.slice(0,10);

  // Go through jobsList (single‐day or multi‐day)
  const dayJobs = (jobsList || []).filter(job => {
    // Your backend may call them start_date/end_date or service_date
    const start = (job.start_date || job.service_date || "").slice(0,10);
    const end   = (job.end_date   || job.start_date    || job.service_date || "").slice(0,10);

    // include if the target falls between start and end (inclusive)
    return start && end && start <= target && target <= end;
  });

  // Group in TYPE_ORDER
  const grouped = TYPE_ORDER.reduce((o, t) => (o[t]=[],o), {});

  dayJobs.forEach(job => {
    // If your job object uses a different “type” key, adjust here
    const type = job.type;
    if (grouped[type]) grouped[type].push(job);
  });

  // Build modal HTML
  header.textContent = target;
  let html = "";

  TYPE_ORDER.forEach(type => {
    const list = grouped[type];
    if (list.length) {
      html += `<div class="bar_${type}">${type}</div><ul>`;
      list.forEach(j => {
        // Adapt these fields if your job object keys differ
        const title = j.title || j.job_title || "Untitled";
        const time  = j.time  || j.service_time  || "";
        html += `<li><strong>${title}</strong>${ time ? ` – ${time}` : "" }</li>`;
      });
      html += `</ul>`;
    }
  });

  if (!html) {
    html = `<p>No jobs on ${target}</p>`;
  }

  content.innerHTML     = html;
  modal.style.display   = "block";
  overlay.style.display = "block";
}
/*


/*
function showModal(dateKey) {
  const modal   = document.getElementById("modal");
  const overlay = document.getElementById("modalOverlay");
  const header  = document.getElementById("modalHeader");
  const content = document.getElementById("modalContent");

  // Filter every job whose start–end span includes dateKey
  const dayJobs = (jobsList || []).filter(job => {
    return job.startDate <= dateKey && dateKey <= job.endDate;
  });

  // Group by TYPE_ORDER
  const grouped = TYPE_ORDER.reduce((o, type) => {
    o[type] = [];
    return o;
  }, {});

  dayJobs.forEach(job => {
    grouped[job.type]?.push(job);
  });

  // Build modal HTML
  header.textContent = dateKey;
  let html = "";

  TYPE_ORDER.forEach(type => {
    const list = grouped[type];
    if (list.length) {
      // colored bar + heading
      html += `<div class="bar_${type}">${type}</div><ul>`;
      list.forEach(job => {
        html += `<li><strong>${job.title}</strong> – ${job.time}</li>`;
      });
      html += `</ul>`;
    }
  });

  if (!html) {
    html = `<p>No jobs on ${dateKey}</p>`;
  }

  content.innerHTML = html;
  modal.style.display   = "block";
  overlay.style.display = "block";
}
*/
function showModal(dateKey) {
  const modal   = document.getElementById("modal");
  const overlay = document.getElementById("modalOverlay");
  const hdr     = document.getElementById("modalHeader");
  const cnt     = document.getElementById("modalContent");
 modal.style.display   = "none";
  overlay.style.display = "none";
  // Format dateKey as "MonthName D, YYYY"
  const [yy, mm, dd] = dateKey.split("-");
  const dateObj = new Date(+yy, +mm - 1, +dd);
  const formatted = dateObj.toLocaleDateString("en-US", {
    month: "long",
    day:   "numeric",
    year:  "numeric"
  });
  hdr.textContent = formatted;

  // 1) Gather service-date events
  const serviceList = events[dateKey] ? [...events[dateKey]] : [];

  // 2) Gather multi-day events whose span covers dateKey
  const allEvents = Object.values(events).flat();
  const spanList  = allEvents.filter(evt =>
    evt.startDate &&
    evt.endDate &&
    evt.startDate <  dateKey &&
    dateKey     <= evt.endDate
  );

  // 3) Merge and sort by TYPE_ORDER then time
  const merged = [...serviceList, ...spanList];
  merged.sort((a, b) => {
    const typeDiff = TYPE_ORDER.indexOf(a.type) - TYPE_ORDER.indexOf(b.type);
    if (typeDiff !== 0) return typeDiff;
    return (a.time || "").localeCompare(b.time || "");
  });

  // 4) Group by type
  const grouped = merged.reduce((o, evt) => {
    (o[evt.type] = o[evt.type] || []).push(evt);
    return o;
  }, {});

  // 5) Build HTML
  let html = "";
  TYPE_ORDER.forEach(type => {
    const list = grouped[type] || [];
    if (list.length) {
      html += `<div class="bar_${type}">${type}</div><ul class="hash-bullets">`;
      list.forEach(e => {
        html += `<li><strong>${e.title}</strong>${ e.time ? ` - ${e.time} ` : "" }</li>`;
      });
      html += `</ul>`;
    }
    console.log(html)
  });

  if (!html) html = `<p>No jobs on ${formatted}</p>`;

  cnt.innerHTML   = html;
  modal.style.display   = "block";
  overlay.style.display = "block";
}

/* just fine
function showModal(dateKey) {
  const modal   = document.getElementById("modal");
  const overlay = document.getElementById("modalOverlay");
  const hdr     = document.getElementById("modalHeader");
  const cnt     = document.getElementById("modalContent");

  // 1) Gather service-date events
  const serviceList = events[dateKey] ? [...events[dateKey]] : [];

  // 2) Gather multi-day events whose span covers dateKey
  const allEvents = Object.values(events).flat();
  const spanList  = allEvents.filter(evt => {
    return evt.startDate &&
           evt.endDate &&
           evt.startDate <  dateKey &&   // strictly before
           dateKey     <= evt.endDate;   // through end
  });

  // 3) Merge and sort
  const merged = [...serviceList, ...spanList];
  merged.sort((a, b) => {
    const typeDiff = TYPE_ORDER.indexOf(a.type) - TYPE_ORDER.indexOf(b.type);
    if (typeDiff !== 0) return typeDiff;
    return (a.time || "").localeCompare(b.time || "");
  });

  // 4) Group by type
  const grouped = merged.reduce((o, evt) => {
    (o[evt.type] = o[evt.type]||[]).push(evt);
    return o;
  }, {});

  // 5) Build HTML
  hdr.textContent = dateKey;
  let html = "";

  TYPE_ORDER.forEach(type => {
    const list = grouped[type] || [];
    if (list.length) {
      html += `<div class="bar_${type}">${type}</div><ul>`;
      list.forEach(e => {
        html += `<li><strong>${e.title}</strong>${ e.time ? ` – ${e.time}` : "" }</li>`;
      });
      html += `</ul>`;
    }
  });

  if (!html) {
    html = `<p>No jobs on ${dateKey}</p>`;
  }

  cnt.innerHTML     = html;
  modal.style.display   = "block";
  overlay.style.display = "block";
}
just fine */

/* good but no dot pop 
function showModal(dateKey){

  const modal   = document.getElementById("modal");
  const overlay = document.getElementById("modalOverlay");
  const hdr     = document.getElementById("modalHeader");
  const cnt     = document.getElementById("modalContent");

// clone & sort by TYPE_ORDER, then by time
const list = (events[dateKey] || []).slice();
list.sort((a, b) => {
  const typeDiff = TYPE_ORDER.indexOf(a.type) - TYPE_ORDER.indexOf(b.type);
  return typeDiff !== 0
    ? typeDiff
    : a.time.localeCompare(b.time);
});

  let html = `<strong>${dateKey}</strong><br>`;
  const grouped = list.reduce((g,e) => {
    (g[e.type] = g[e.type]||[]).push(e);
    return g;
  }, {});

  TYPE_ORDER.forEach(type => {
    if (grouped[type]?.length) {
      html += `<div class="bar_${type}">${type}</div><ul>`;
      grouped[type].forEach(e =>
        html += `<li><strong>${e.title}</strong> – ${e.time}</li>`
      );
      html += `</ul>`;
    }
  });

  hdr.innerHTML     = "";
  cnt.innerHTML     = html;
  modal.style.display   = "block";
  overlay.style.display = "block";
}
*/

function closeModal(){
  document.getElementById("modal").style.display="none";
  document.getElementById("modalOverlay").style.display="none";
}

document.addEventListener("DOMContentLoaded", loadCalendarData);
document.getElementById("refreshButton")?.addEventListener("click", loadCalendarData);